//*******************************************************************************************************************************************
// The class is used to calculate two components of the saccade lengths: random error and systematic error.
//*******************************************************************************************************************************************

package ezreader10;

import java.util.*;

class Saccade {
    
    // Initialize class:
    Random r = new Random();
    
    //**************************************************************************
    
    double randomError(double intendedSaccade) {
        
        // Calculate random error component of saccade:
        double result = r.nextGaussian() * (EZReader10.Eta1 + (Math.abs(intendedSaccade) * EZReader10.Eta2));
        return result;
    }
    
    //**************************************************************************
     
    double systematicError(double intendedSaccade, double launchSiteFixDur) {
        
        // Calculate systematic error component of saccade:
        double result = (EZReader10.Psi - Math.abs(intendedSaccade)) * ((EZReader10.Omega1 - Math.log(launchSiteFixDur)) /  EZReader10.Omega2);
        if (intendedSaccade < 0) result *= -1.0;
        return result;
    }
}

//*******************************************************************************************************************************************
